import { View, Text, ScrollView } from "react-native";
import React from "react";
import IndividualItem from "./IndividualItem";
import { groupProductStyle } from "./groupProduct.style";
import { processData } from "./processData";
import useLangTranslation from "../../../../../../../hooks/useLangTranslation";

const GroupProducts = (props) => {
    const { trans } = useLangTranslation();
    const { groupProducts, setDisableBtn, inputData, setInputData } = props;
    const { productDetails, otherData } = groupProducts || {};
    let groupProduct = processData(productDetails, otherData);
    return (
        <View>
            <Text style={groupProductStyle.groupTitle}>
                {trans("This is a grouped product. Select the ones you want.")}
            </Text>
            <ScrollView
                style={groupProductStyle.groupCont}
                nestedScrollEnabled={true}
            >
                {groupProduct?.map((item, index) => (
                    <IndividualItem
                        key={index}
                        item={item}
                        setDisableBtn={setDisableBtn}
                        inputData={inputData}
                        setInputData={setInputData}
                    />
                ))}
            </ScrollView>
        </View>
    );
};

export default GroupProducts;
